﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/Site.Master" Inherits="System.Web.Mvc.ViewPage<ItineraryDetailsViewModel>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Plan My Night - <%:Model.Name%>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="panel">
        <h2><span>Edit: <%:Model.Name%></span></h2>
        <div class="innerPanel">
            <div class="items">
                <fieldset>
                <% using (Html.BeginForm<ItinerariesController>(c => c.Save(null, null, null)))
                   { %>
                    <%=Html.AntiForgeryToken()%>
                    <div class="fieldsA">
                        <p>
                            <label for="name">Name:</label><br />
                            <%=Html.TextBox("name", Model.Name)%>
                        </p>
                        <p>
                            <label for="description">Description:</label><br />
                            <%=Html.TextArea("description", Model.Description, new { style = "width:100%" })%>
                        </p>
                        <p>
                            <label for="isPublic"><%=Html.CheckBox("isPublic", Model.IsPublic)%> Is Public</label>
                        </p>
                        <div class="submit">
                            <input type="submit" value="Save" />
                            |
                            <% if (Model.Id != 0)
                               { %> <%=Html.ActionLink<ItinerariesController>(c => c.Details(Model.Id), "Cancel")%>
                            <% } 
                               else 
                               { %>
                                   <%= Html.ActionLink<SearchController>(c => c.Index(), "Cancel") %>
                            <% } %>
                        </div>
                    </div>
                <% } %>
                </fieldset>
                <ol class="activities">
                <% foreach (var item in Model.Activities) %>
                <% { %>
                    <li>
                        <h3><%:item.Entity.Name%></h3>
                        <p>
                            <%:item.Entity.Street%><br />
                            <%:item.Entity.City%>, <%:item.Entity.State%>
                            <%:item.Entity.Zip%><br />
                            Phone: <%:item.Entity.PhoneNumber%>
                        <% if (item.EstimatedMinutes > 0)
                           { %>
                            <br />Estimated remain time: <%= item.EstimatedMinutes %> minutes.
                        <% } %>
                        </p>
                    </li>
                <% } %>
                </ol>
            <% if (Model.EstimatedMinutes > 0)
               { %>
                <p>Total estimated time: <%:TimeHelper.GetFriendlyTime(Model.EstimatedMinutes)%>
                   + travel time.
                </p>
            <% } %>
            </div>
            <div class="toolbox">
                <%--Addin Boxes--%>
                <%
                    foreach(var action in Model.AddinBoxes)
                    {
                        Html.RenderAddinRoute(action);
                    }
                %>
                <div class="pager">
                    <ul>
                        <li><%=Html.ActionLink<SearchController>(c => c.Index(), "Add or rearrange activities")%></li>
                        <%--Addin links--%>
                        <% foreach(var link in Model.AddinLinks) { %>
                            <li><%= Html.RouteLink(link.LinkText, link.RouteLink, link.Attributes)%></li>
                        <% } %>        
                    </ul>
                </div>
            </div>
        </div>
    </div>
</asp:Content>